%
restoredefaultpath

clear
close all
clc

addpath('./../')

pwdStr = pwd;
HORIZON ='.\..\..\';
addpath(fullfile(HORIZON,'tools'))
addpath(fullfile(HORIZON,'soda-ssp-mo'))
soda -docinstall

load('./../20110930a/worker001/soildepth.mat')


FS = 14;


[nRows,nCols] = size(soilDepth);
res = 3.0; % meter
x = (0:nCols-1)*res;
y = (0:nRows-1)*res;


iFig = newFigNumber(1001);
sodaSubplotScreen(1,2,1,'figureNumber',iFig)
imagesc(x,y,soilDepth)
colormap(interp1([0;1],[1,1,1;[17,66,17]/255],linspace(0,1,64)))
set(gca,'ydir','normal','xtick',x,'ytick',y)
axis image
xlabel('x: along-slope distance [m]','fontsize',FS)
ylabel('y: upslope distance [m]','fontsize',FS)
title('soil depth','fontsize',FS)

hColorbar = colorbar;
setColorbarTitle(hColorbar,'[m]')
set(iFig,'color','none')
set(iFig,'paperpositionmode','auto','inverthardcopy','off')

print(iFig,'soildepth.png','-r300','-dpng')
print(iFig,'soildepth.eps','-r300','-depsc2','-loose')

% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

sodaSubplotScreen(1,2,2,'figureNumber',iFig+1)
cMap = [interp1([0;1],[1,1,1;[17,66,17]/255],linspace(0,1,64))];
cLimLow = min(soilDepth(:));
cLimHigh = max(soilDepth(:));

imagescv(x,y,soilDepth,cMap,cLimLow,cLimHigh)
box on
set(gca,'xtick',x,'ytick',y,'ydir','normal')
axis image
xlabel('x: along-slope distance [m]','fontsize',FS)
ylabel('y: upslope distance [m]','fontsize',FS)
title('soil depth','fontsize',FS)

% hColorbar = colorbar;
% setColorbarTitle(hColorbar,'[m]')

H=colorbarv(cMap,cLimLow,cLimHigh);
h=get(H{2}(1),'Parent');
axes(h)
title('[m]')


set(iFig+1,'color','none')
set(iFig+1,'paperpositionmode','auto','inverthardcopy','off')

print(iFig+1,'soildepthv.png','-r300','-dpng')
print(iFig+1,'soildepthv.eps','-r300','-depsc2','-loose')


