
restoredefaultpath

clear
close all
clc

pwdStr = pwd;
HORIZON = fullfile(pwdStr(1:min(findstr(pwdStr,filesep))),...
    getenv('COMPUTERNAME'),'synchronized','horizon');
addpath(fullfile(HORIZON,'tools'))
addpath(fullfile(HORIZON,'soda-ssp-mo'))
soda -docinstall

load('./../20110930a/worker001/soildepth.mat')


FS = 14;


[nRows,nCols] = size(soilDepth);
res = 3.0; % meter
x = (0:nCols-1)*res;
y = (0:nRows-1)*res;



v = [1.0,0.75,0.25];
%vText = {'','low (0.01 m^{-1}hr^{-1})','high (0.30 m^{-1}hr^{-1})'};
vText = {'','low (0.01 hr^{-1})','high (0.30 hr^{-1})'};
sinkRate = v(2)*ones(size(soilDepth));
sinkRate(y==0,:) = v(1);


                 
extraLeakageNodes = [4,7,1;...
                     6,4,1;...
                     7,1,1;...
                     11,3,1;...
                     14,6,1]


for k=1:size(extraLeakageNodes,1)
    sinkRate(extraLeakageNodes(k,1),extraLeakageNodes(k,2)) = v(3);
end



iFig = newFigNumber(1001);
sodaSubplotScreen(1,2,1,'figureNumber',iFig)
axes('pos',[0.025    0.1100    0.6935    0.8150])
%posImagesc = get(gca,'pos');
imagesc(x,y,sinkRate,[0,1]);
set(gca,'ydir','normal','xtick',x,'ytick',y)
colormap('gray')
axis image
hImagesc = gca;
xlabel('x: along-slope distance [m]','fontsize',FS)
ylabel('y: upslope distance [m]','fontsize',FS)
% title('soil depth','fontsize',FS)

posImagesc = plotboxpos(hImagesc);

aspRatio = 15/7;
for k=2:3
%     posImagesc = [0.1300    0.1100    0.6935    0.8150];
    posAx(1) = posImagesc(1)+posImagesc(3)+0.01;
    posAx(2) = posImagesc(2)+(k-1)*0.05;
    posAx(3) = 0.75*((1/7)*posImagesc(3));
    posAx(4) = 0.75*(1/15)*posImagesc(4);
    axes('position',posAx)
    imagesc(1,1,v(k),[0,1])
    set(gca,'xtick',[],'ytick',[])
    text(1.75,1,vText{k},'fontsize',FS)
    if k==3
        text(0.75,0,'sink rate','fontsize',FS)
    end
end


% hColorbar = colorbar;
% setColorbarTitle(hColorbar,'[m]')
set(iFig,'color','none')
set(iFig,'paperpositionmode','auto','inverthardcopy','off')

print(iFig,'rsink.png','-r300','-dpng')
print(iFig,'rsink.eps','-r300','-depsc2','-loose')