if viz
    if elems.n<150
        hFig = subplotScreen;
        set(gcf,'numbertitle','off','name','mesh',...
            'InvertHardCopy','off','paperpositionmode','auto')

        nodeInfo = swmsReadBlockH();
        elemInfo = swmsReadBlockI();

        subplot(2,2,1)
        vizTetra(elemInfo.values(:,2:5),nodeInfo.values(:,3),...
            nodeInfo.values(:,4),...
            nodeInfo.values(:,5),'plot3')
        title('mesh --top view')
        view([0,90])
        axis tight
        xlabel('x')
        ylabel('y')
        zlabel('z')

        subplot(2,2,2)
        vizTetra(elemInfo.values(:,2:5),nodeInfo.values(:,3),...
            nodeInfo.values(:,4),...
            nodeInfo.values(:,5),'plot3')
        title('mesh --side view')
        view([90,0])
        axis tight
        xlabel('x')
        ylabel('y')
        zlabel('z')

        subplot(2,2,3)
        vizTetra(elemInfo.values(:,2:5),nodeInfo.values(:,3),...
            nodeInfo.values(:,4),...
            nodeInfo.values(:,5),'plot3')
        title('mesh --front view')
        view([0,0])
        axis tight
        xlabel('x')
        ylabel('y')
        zlabel('z')



        set(hFig,'paperunits','centimeter')
        pos = get(hFig,'position');
        r = pos(3)/pos(4);
        maxWidth = 26;
        set(hFig,'paperposition',[1,1,maxWidth,maxWidth/r])


        if saveFigs
            print(hFig,'mesh-top-view','-depsc','-r300','-loose')
            print(hFig,'mesh-top-view','-dpng','-r300')
        end
    else
        disp('skipping visualization of mesh --too many nodes')
    end

    clear nodeInfo
    clear elemInfo
    clear maxWidth
    clear r
    clear pos
    
end % if viz    
    