function blockStr = readTemplate(blockID)

switch blockID
    case 'a'
        % basic information
        fname = 'blocka.txt.template';
    case 'b'
        % material information
        fname = 'blockb.txt.template';
    case 'c'
        % time information
        fname = 'blockc.txt.template';
    case 'd'
        % root water uptake information
        fname = 'blockd.txt.template';
    case 'e'
        % seepage face information
        fname = 'blocke.txt.template';
    case 'f'
        % drainage information
        disp('no template available')
    case 'g'
        % solute transport information
        disp('no template available')
    case 'h'
        % nodal information
        fname = 'blockh.txt.template';
    case 'i'
        % element information
        fname = 'blocki.txt.template';
    case 'j'
        % boundary geometry information
        fname = 'blockj.txt.template';
    case 'k'
        % atmospheric information
        fname = 'blockk.txt.template';
    otherwise
        error('unknown string')
end

blockStr = '';
firstLine = true;
fid = fopen(fullfile(pwd,'templates',fname));
while true
    s = fgetl(fid);
    if ~ischar(s)
        break
    else
        if ~firstLine
            blockStr = [blockStr,char(10)];
        end
    end
    blockStr = [blockStr,s];
    firstLine = false;
end
fclose(fid);