if viz

    vertOffset = false;

    if visualizeTransects
        if exist('thetas4D','var')==1
            % do nothing
        else
            if exist('thetas','var')==1
                thetas4D = conv2dto4d(thetas,nRows,nCols,nLays,nodes);
            else
                try
                    [thetas,thetasTimes] = readOutput(pwd,'th.out',true);
                    thetas4D = conv2dto4d(thetas,nRows,nCols,nLays,nodes);
                catch
                    disp('Error processing water content information-- can''t plot transects.')
                end
            end
        end    

        % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
        if ~any(isnan(thetas4D(:)))
            zRes = 0.2;
            thetas4D = conv2dto4d(thetas,nRows,nCols,nLays,nodes);

            hFigThetas = subplotScreen;
            set(hFigThetas,'InvertHardCopy','off','paperpositionmode','auto')
            for iTime=1:size(thetas4D,4)
                transectOf('Thetas',nodes,thetas4D,transect.x,transect.y,iTime,thetasTimes,hFigThetas,vertOffset,zRes)
                if saveFigs
                    print(hFigThetas,['transectOfThetas_',sprintf('%03d',iTime)],'-depsc','-r300','-loose')
                    print(hFigThetas,['transectOfThetas_',sprintf('%03d',iTime)],'-dpng','-r300')
                else
                    drawnow
                end
            end
        else
            disp('NaNs in thetas array. --Can''t plot water contents')
        end % if ~any(isnan(thetas(:)))

        % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
    end % visualizeTransects

    clear hFigThetas
    clear iTime
    
end % if viz