if viz

    if includeRoot

        FeddesInfoFile = fullfile(pwd,'SWMS_3D.IN','SELECTOR.IN');

        fid = fopen(FeddesInfoFile,'rt');

        fid = goToBlockStart(fid,'B');
        fid = skipLines(fid,2);
        C = textscan(fid,'%d',1);
        nMaterials = C{1};
        clear C

        fid = goToBlockStart(fid,'D');
        fid = skipLines(fid,2);
        pos = ftell(fid);
        C = textscan(fid,'%f%f%f%f%f%f');

        P0 = C{1};
        P2H = C{2};
        P2L = C{3};
        P3 = C{4};
        r2H = C{5};
        r2L = C{6};

        clear C

        status = fseek(fid,pos,'bof');
        fid = skipLines(fid,2);

        C = textscan(fid,repmat('%f',[1,nMaterials]),1);
        status = fclose(fid);

        for iMaterial = 1:nMaterials
            POptm(iMaterial,1) = C{iMaterial};
        end


        if P2L==P2H
            P2 = P2L;
            clear P2H 
            clear P2L
        else
            warning('P2L~=P2H')
        end



        hFig = subplotScreen;
        set(hFig,'invertHardCopy','off',...
            'paperpositionmode','auto',...
            'numbertitle','off',...
            'name','feddes')

        subplot(1,1,1,'fontsize',16)

        if (numel(POptm)>1 & numel(unique(POptm))==1) || numel(POptm)==1

            P1 = POptm(1);

            plot([P0,P1,P2,P3],[0,1,1,0],'.-','linewidth',2)
            hold on
            if numel(POptm)==1
                s = '';
            else
                s = 'all';
            end
            text(P0,0,['P0'])
            text(P1,1,['P1_{',s,'}'])
            text(P2,1,['P2'])
            text(P3,0,['P3'])

        else
            P0 = ones(nMaterials,1)*P0;
            P1 = POptm;
            P2 = ones(nMaterials,1)*P2;
            P3 = ones(nMaterials,1)*P3;

            plot([P0,P1,P2,P3],[0,1,1,0],'.-','linewidth',2)
            hold on
            text(P0(iMaterial),0,['P0'])    
            text(P2(iMaterial),1,['P2'])
            text(P3(iMaterial),0,['P3'])
            for iMaterial=1:nMaterials
                text(P1(iMaterial),1,['P1_{',num2str(iMaterial),'}'])
            end

        end

        xlabel(['pressure head [',swmsLengthUnits,']'])
        ylabel('transpiration efficieny \alpha')

        set(gca,'ylim',[0,1.1],'xtick',unique([P0,P1,P2,P3]),'ytick',[0,1])

        if saveFigs
            print(gcf,'feddes.eps','-depsc','-r300','-loose')
            print(gcf,'feddes.png','-dpng','-r300')
        end


        clear P0
        clear P1
        clear P2
        clear P3
        clear P2L
        clear P2H
        clear hFig
        clear fid
        clear status
        clear C
        clear FeddesInfoFile
        clear POptm
        clear iMaterial
        clear nMaterials
        clear r2L
        clear r2H
        clear pos 
        clear s

    else
        disp('Root extraction not active. Skipping visualization of Feddes parameters.')
    end % if includeRoot


end % if viz

