%
restoredefaultpath

clear
close all
clc

pwdStr = pwd;
addpath(fullfile(pwdStr,'fileio'))
addpath(fullfile(pwdStr,'viz'))
addpath(fullfile(pwdStr,'tools'))

% HORIZON = fullfile(pwdStr(1:min(findstr(pwdStr,filesep))),...
%     getenv('COMPUTERNAME'),'synchronized','horizon');
HORIZON = '.\..\..\..\';
addpath(fullfile(HORIZON,'tools'))
addpath(fullfile(HORIZON,'soda-ssp-mo'))
soda -docinstall

load('./../../20110929a/worker001/water-balance-components.mat','vInnTrue',...
    'vSinkTrue','vSeepTrue')



load('./../reset-results-720-4-40-0.mat')

paretoOptimals = evalResults(find(evalResults(:,sodaPar.paretoCol)>-2),:);



[tmp0,tmp1,tmp2] = unique(paretoOptimals(:,sodaPar.parCols),'rows','first');
n=size(tmp0,1);
evalResultsPart=sortrows([paretoOptimals(tmp1,[1:1+sodaPar.nOptPars]),...
    repmat(NaN,[n,sodaPar.nObjs+1]),repmat(false,[n,1])],1);

for r = 1:size(evalResultsPart,1)
    
    if ~(evalResultsPart(r,1)==620)
        continue
    end

    if ~all(isnan(evalResultsPart(r,:))) && ~evalResultsPart(r,sodaPar.evalCol)
        % the model has not been evaluated with...
        % the parameters in the current row

        % read a line from the matrix containing rows of parameter vectors
        parVec = evalResultsPart(r,sodaPar.parCols);

        % call the ensemble Kalman Filter:
        if sodaPar.crashAndBurn
            [ensemblePred,mStatesInn,mStatesNOKF,sodaPar] = sodaEnKF(sodaPar,parVec);

            % compare the model result with the measurements and calculate the...
            % corresponding score according to an objective function:
            for iObj = 1:sodaPar.nObjs
                eval(sodaPar.objCallStrs{iObj})
                if isnan(objScore)
                    warning('SODA:objectiveScoreEqualsNaN',...
                        'Objective score is NaN')
                end
                evalResultsPart(r,sodaPar.objCols(1,iObj)) = objScore;
            end                
        else
            try
                [ensemblePred,mStatesInn,mStatesNOKF,sodaPar] = sodaEnKF(sodaPar,parVec);

                gridOfInnColorTwoSpace(sodaPar,mStatesInn,parVec,...
                    'modeStr','state updates','yUnitStr','m','xLabel','Time [hr]',...
                    'yLabel',['state updates on ',char(10),'pressure head [m]'],...
                    'yLimMin',-0.07,'yLimMax',0.01,'showParameters',false)

                set(gcf,'color',[1,1,1],'inverthardcopy','off','paperpositionmode','auto')
                print(gcf,['gridOfInn-',num2str(evalResultsPart(r,1),'%03d'),'.eps'],'-depsc2','-r300','-loose')
                print(gcf,['gridOfInn-',num2str(evalResultsPart(r,1),'%03d'),'.png'],'-dpng','-r300')

                % compare the model result with the measurements and calculate the...
                % corresponding score according to an objective function:
                for iObj = 1:sodaPar.nObjs
                    eval(sodaPar.objCallStrs{iObj})
                    if isnan(objScore)
                        warning('SODA:objectiveScoreEqualsNaN',...
                            'Objective score is NaN')
                    end
                    evalResultsPart(r,sodaPar.objCols(1,iObj)) = objScore;
                end                
            catch
                evalResultsPart(r,sodaPar.objCols) = sodaPar.badScore;
            end
        end

        % Set the 'model evaluated' flag to true:
        evalResultsPart(r,sodaPar.evalCol) = true;

    end
    
    break
    
end

objScores = evalResultsPart(:,sodaPar.objCols);
goldbergs = sodaCalcPareto(objScores,'g')




% xlims = [min(ensemblePred(:)+mStatesInn(:)),max(ensemblePred(:)+mStatesInn(:))];
% ylims = [min(mStatesInn(:)),max(mStatesInn(:))];
FS=18;
figure('pos',[378   423   830   525])
clf
%subplot(1,3,1)
axes('pos',[0.15,0.15,0.725,0.725])
v1 = [7,41,51,94];
h1=plot(ensemblePred(1:end-1,v1)+mStatesInn(1:end-1,v1),mStatesInn(2:end,v1),'-');
set(h1(1),'markersize',4,'markeredgecolor','b','markerfacecolor','b','marker','o','color',[0,0,1])
set(h1(2),'markersize',4,'markeredgecolor',[0,0.5,0],'markerfacecolor',[0,0.5,0],'marker','s','color',[0,0.5,0])
set(h1(3),'markersize',5,'markeredgecolor','r','markerfacecolor','r','marker','d','color',[1,0,0])
%set(h1(4),'markersize',4,'markeredgecolor','m','markerfacecolor','m','marker','v','color',[1,0,1])
set(h1(4),'markersize',4,'markeredgecolor',[0,0,0],'markerfacecolor',[0,0,0],'marker','^','color',[0,0,0])
% set(gca,'xlim',xlims,'ylim',ylims,'fontsize',FS)
hLeg=legend(h1,'X00Y18','X06Y30','X09Y15','X18Y09');
set(hLeg,'fontsize',FS-4,'location','SouthWest')
set(gca,'fontsize',FS)
title('hotspots: state updating')
xlabel('posterior_{ t - 1} [m]')
ylabel('state update_{ t} [m]')

set(gcf,'color',[1,1,1],'inverthardcopy','off','paperpositionmode','auto')
print(gcf,['signatures-',num2str(evalResultsPart(r,1),'%03d'),'.eps'],'-depsc2','-r300','-loose')
print(gcf,['signatures-',num2str(evalResultsPart(r,1),'%03d'),'.png'],'-dpng','-r300')









% 
% xlims = [min(ensemblePred(:)+mStatesInn(:)),max(ensemblePred(:)+mStatesInn(:))];
% ylims = [min(mStatesInn(:)),max(mStatesInn(:))];
% FS=12;
% figure('pos',[378   423   830   525])
% %subplot(1,3,1)
% axes('pos',[0.1,0.1,0.28,0.82])
% v1 = [7,41,51,89,94];
% h1=plot(ensemblePred(1:end-1,v1)+mStatesInn(1:end-1,v1),mStatesInn(2:end,v1),'.');
% set(gca,'xlim',xlims,'ylim',ylims,'fontsize',FS)
% title('hotspots')
% xlabel('posterior_{ t - 1}')
% ylabel('state update_{ t}')
% %subplot(1,3,2)
% axes('pos',[0.40,0.1,0.28,0.82])
% v2 = [6,8,21,22,23,25,26,27,35,36,37,40,42,50,52,65,66,67,73,74,75,78,79,80,88,90,93,95];
% h2=plot(ensemblePred(:,v2)+mStatesInn(:,v2),mStatesInn(:,v2),'.');
% set(gca,'xlim',xlims,'ylim',ylims,'fontsize',FS,'yticklabel',[])
% title('hotspot neighbors')
% xlabel('posterior_{ t - 1}')
% % ylabel('state update_{t}')
% % subplot(1,3,3)
% axes('pos',[0.7,0.1,0.28,0.82])
% v3 = setdiff(1:105,union(v1,v2));
% h3=plot(ensemblePred(:,v3)+mStatesInn(:,v3),mStatesInn(:,v3),'.');
% set(gca,'xlim',xlims,'ylim',ylims,'fontsize',FS,'yticklabel',[])
% title('others')
% xlabel('posterior_{ t - 1}')
% % ylabel('state update_{t}')
% 
% set(gcf,'color',[1,1,1],'inverthardcopy','off','paperpositionmode','auto')
% print(gcf,['signatures-',num2str(evalResultsPart(r,1),'%03d'),'.eps'],'-depsc2','-r300','-loose')
% print(gcf,['signatures-',num2str(evalResultsPart(r,1),'%03d'),'.png'],'-dpng','-r300')








% xlims = [min(ensemblePred(:)+mStatesInn(:)),max(ensemblePred(:)+mStatesInn(:))];
% ylims = [min(mStatesInn(:)),max(mStatesInn(:))];
% FS=12;
% figure('pos',[560   303   684   645])
% subplot(1,3,1)
% %axes('pos',[0.11,0.7,0.88,0.28])
% v1 = [7,41,51,89,94];
% h1=plot(ensemblePred(1:end-1,v1)+mStatesInn(1:end-1,v1),mStatesInn(2:end,v1),'.');
% set(gca,'xlim',xlims,'ylim',ylims,'fontsize',FS)
% title('hotspots')
% xlabel('posterior_{ t - 1}')
% ylabel('state update_{ t}')
% subplot(1,3,2)
% %axes('pos',[0.11,0.08,0.88,0.28])
% v2 = [6,8,21,22,23,25,26,27,35,36,37,40,42,50,52,65,66,67,73,74,75,78,79,80,88,90,93,95];
% h2=plot(ensemblePred(:,v2)+mStatesInn(:,v2),mStatesInn(:,v2),'.');
% set(gca,'xlim',xlims,'ylim',ylims,'fontsize',FS,'yticklabel',[])
% title('hotspot neighbors')
% xlabel('posterior_{ t - 1}')
% % ylabel('state update_{t}')
% subplot(1,3,3)
% %axes('pos',[0.11,0.08,0.88,0.28])
% v3 = setdiff(1:105,union(v1,v2));
% h3=plot(ensemblePred(:,v3)+mStatesInn(:,v3),mStatesInn(:,v3),'.');
% set(gca,'xlim',xlims,'ylim',ylims,'fontsize',FS,'yticklabel',[])
% title('others')
% xlabel('posterior_{ t - 1}')
% % ylabel('state update_{t}')
% 
% set(gcf,'color',[1,1,1],'inverthardcopy','off','paperpositionmode','auto')
% print(gcf,['signatures-',num2str(evalResultsPart(r,1),'%03d'),'.eps'],'-depsc2','-r300','-loose')
% print(gcf,['signatures-',num2str(evalResultsPart(r,1),'%03d'),'.png'],'-dpng','-r300')
% 
% 




