if viz
% read flow output file and visualize:
    [flow,flowTimes] = readOutput(pwd,'Q.out',false);
    hFig = subplotScreen;
    set(hFig,'numbertitle','off','name','discharge',...
        'InvertHardCopy','off','paperpositionmode','auto')

    subplot(1,2,1)
    imagesc(flowTimes,1:nodes.n,flow)
    colorbar;
    titleStr = ['cumulative water flux per node [',swmsLengthUnits,'^3]'];
    title(titleStr)
    xlabel(['time [',swmsTimeUnits,']'])
    ylabel('node ID')

    subplot(1,2,2)
    stairs(flowTimes,flow','.-')
    xlabel(['time [',swmsTimeUnits,']'])
    ylabel(titleStr)
    set(gca,'xlim',[min(flowTimes),max(flowTimes)])
    title('per-node discharge')

    set(hFig,'paperunits','centimeter')
    pos = get(hFig,'position');
    r = pos(3)/pos(4);
    maxWidth = 26;
    set(hFig,'paperposition',[1,1,maxWidth,maxWidth/r])

    if saveFigs
        print(hFig,'perNodeDischarge','-depsc','-r300','-loose')
        print(hFig,'perNodeDischarge','-dpng','-r300')    
    end

    clear titleStr
    clear r 
    clear pos
    clear maxWidth
end % if viz