%
restoredefaultpath

clear
close all
clc

pwdStr = pwd;
addpath(fullfile(pwdStr,'fileio'))
addpath(fullfile(pwdStr,'viz'))
addpath(fullfile(pwdStr,'tools'))

HORIZON = fullfile(pwdStr(1:min(findstr(pwdStr,filesep))),...
    getenv('COMPUTERNAME'),'synchronized','horizon');

addpath(fullfile(HORIZON,'tools'))
addpath(fullfile(HORIZON,'soda-ssp-mo'))
soda -docinstall

load('./../../20110929a/worker001/water-balance-components.mat','vInnTrue',...
    'vSinkTrue','vSeepTrue')



load('./../reset-results-720-4-40-0.mat')

cMap = flipud(colormap(gray(256)));
x=linspace(0,1,size(cMap,1))';
var = sum(mConstants{1,2}>0,1);
cLimMin = min(var(:));
cLimMax = 50%max(var(:));
yi = (var(:)-cLimMin)./(cLimMax-cLimMin);
yi(yi<0)=0;
yi(yi>1)=1;

reds = interp1(x,cMap(:,1),yi);
greens = interp1(x,cMap(:,2),yi);
blues = interp1(x,cMap(:,3),yi);

%mint= [ 0.5172    0.9990    0.1612];
lineColor1 = [1,0,1];
lineColor2 = [0,0,1];

gridOfInnColorTwoSpace(sodaPar,mConstants{1,2},[NaN,NaN],...
    'bgColor',[reds,greens,blues],'showParameters',false,...
    'showLegend',false,'modeStr','states','yLimMin',-0.5,...
    'yLimMax',0.25,'lineColor1',lineColor1,...
    'lineColor2',lineColor2,...
    'xLabel','Time [hr]','yLabel','pressure head [m]','linewidth',1.2)

axes('pos',[0.83,0.12,0.05,0.15])
imagesc(1,linspace(cLimMin,cLimMax,size(cMap,1)),flipud(cMap))
set(gca,'ydir','normal','xtick',[],'ytick',[cLimMin,cLimMax],'yticklabel',{num2str(cLimMin),['>',num2str(cLimMax)]})
xlabel(['duration of saturated',char(10),'conditions [hours]',char(10)])
colormap(cMap)




set(gcf,'color',[1,1,1],'inverthardcopy','off','paperpositionmode','auto')
print(gcf,'gridOfStates.eps','-depsc2','-r300','-loose')
print(gcf,'gridOfStates.png','-dpng','-r300')






